

generate_data <- function(n){
 # E[C] = a_c
 a_c = 0 
 C <- rnorm(n, a_c, 1)
 
 # p(A = 1 | C) = 1/{1 + exp(b_0 + b_c*C)}
 b_0 = 0.5 
 b_c = 0.5 
 p_A1 <- 1/(1 + exp(b_0 + b_c*C))
 A <- rbinom(n, size=1, prob=p_A1)
 
 # p(M | C, A) = 1/{1 + exp(c_0 + c_c*C + c_a*A + c_ac*A*C)}
 c_0 = 0.5
 c_c = 1
 c_a = 0.5 
 c_ac = -1
 p_M1 <- 1/(1 + exp(c_0 + c_c*C + c_a*A + c_ac*A*C))
 M <- rbinom(n, size=1, prob=p_M1)
 
 # p(Y | C, A, M) = d_0 + d_c*C + d_a*A + d_ac*A*C + d_m*M + d_cm*C*M + d_am*A*M + d_acm*A*C*M
 d_0 = 1 
 d_c = 1 
 d_a = 2 
 d_ac = -2  
 d_m = 1 
 d_cm = 3 
 d_am = 1 
 d_acm = 1 
 eps <- rnorm(n, 0, 1)
 Y <- d_0 + d_c*C + d_a*A + d_ac*A*C + d_m*M + d_cm*C*M + d_am*A*M + d_acm*A*C*M + eps
 
 # Data 
 dat = data.frame(1, C, A, A*C, M, C*M, A*M, A*C*M, Y)
 colnames(dat) = c("(Intercept)", "C", "A", "AC", "M", "CM", "AM", "ACM", "Y")
 
 # Coefficinets
 beta_a = -c(b_0, b_c)
 names(beta_a) = c("(Intercept)", "C")
 beta_m = -c(c_0, c_c, c_a, c_ac)
 names(beta_m) = c("(Intercept)", "C", "A", "AC")
 beta_y = c(d_0, d_c, d_a, d_ac, d_m, d_cm, d_am, d_acm)
 names(beta_y) = c("(Intercept)", "C", "A", "AC", "M", "CM", "AM", "ACM")
 
 # Probabilities
 p_c = dnorm(C, 0, 1)
 p_a_c = A*p_A1 + (1-A)*(1 - p_A1)
 p_m_ca = M*p_M1 + (1-M)*(1 - p_M1)
 p_y_cam = dnorm(eps, 0, 1)
 prob = list(p_c = p_c, 
             p_a_c = p_a_c, 
             p_m_ca = p_m_ca, 
             p_y_cam = p_y_cam)

 
 log_lik = sum(log(p_c) + log(p_a_c) + log(p_m_ca) + log(p_y_cam))
 
 
 return(list(data=dat, 
             beta_a=beta_a, 
             beta_m=beta_m, 
             beta_y=beta_y, 
             prob = prob, 
             mle = log_lik))
}

